/*******************************************************************************
 * Copyright (C) Ken Webb 2007
 ******************************************************************************/
package org.topcased.modeler.network.netdiag.commands;

import java.util.Iterator;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.topcased.modeler.ModelerPropertyConstants;
import org.topcased.modeler.commands.AbstractRestoreConnectionCommand;
import org.topcased.modeler.di.model.GraphEdge;
import org.topcased.modeler.di.model.GraphElement;
import org.topcased.modeler.di.model.util.DIUtils;
import org.topcased.modeler.network.netdiag.NetworkDiagramSimpleObjectConstants;
import org.topcased.modeler.utils.Utils;
import org.topcased.network.Node;

/**
 * Node restore connection command
 * 
 * @generated
 */
public class NodeRestoreConnectionCommand extends
		AbstractRestoreConnectionCommand {
	/**
	 * @param part the EditPart that is restored
	 * @generated
	 */
	public NodeRestoreConnectionCommand(EditPart part) {
		super(part);
	}

	/**
	 * @see org.topcased.modeler.commands.AbstractRestoreConnectionCommand#initializeCommands()
	 * @generated
	 */
	protected void initializeCommands() {

		GraphElement elt = getGraphElement();
		EObject eltObject = Utils.getElement(elt);

		if (eltObject instanceof Node) {
			Iterator itDiagContents = getModeler().getActiveDiagram()
					.eAllContents();
			while (itDiagContents.hasNext()) {
				Object obj = itDiagContents.next();
				// FIXME Change the way to handle EList GraphNodes
				if (obj instanceof GraphElement
						&& DIUtils
								.getProperty(
										(GraphElement) obj,
										ModelerPropertyConstants.ESTRUCTURAL_FEATURE_ID) == null) {
					boolean autoRef = obj.equals(elt);
					GraphElement elt2 = (GraphElement) obj;
					EObject eltObject2 = Utils.getElement(elt2);
					if (eltObject2 instanceof Node) {
						if (autoRef) {
							// autoRef not allowed
						} else {
							// if the elt is the source of the edge or if it is the target and that the SourceTargetCouple is reversible
							createLinksFromNodeToNode(elt, elt2);
							// if elt is the target of the edge or if it is the source and that the SourceTargetCouple is reversible
							createLinksFromNodeToNode(elt2, elt);
						}
					}
				}
			}
		}
	}

	/**
	 * @param srcElt the source element
	 * @param targetElt the target element
	 * @generated
	 */
	private void createLinksFromNodeToNode(GraphElement srcElt,
			GraphElement targetElt) {
		Node sourceObject = (Node) Utils.getElement(srcElt);
		Node targetObject = (Node) Utils.getElement(targetElt);

		if (sourceObject.getOutlinks().contains(targetObject)
				&& targetObject.getInlinks().contains(sourceObject)) {
			// check if the relation does not exists yet
			if (getExistingEdges(srcElt, targetElt,
					NetworkDiagramSimpleObjectConstants.SIMPLE_OBJECT_LINKS)
					.size() == 0) {
				GraphEdge edge = Utils
						.createGraphEdge(NetworkDiagramSimpleObjectConstants.SIMPLE_OBJECT_LINKS);
				LinksEdgeCreationCommand cmd = new LinksEdgeCreationCommand(
						null, edge, srcElt, false);
				cmd.setTarget(targetElt);
				add(cmd);
			}
		}
	}

}