/*******************************************************************************
 * Copyright (C) Ken Webb 2007
 ******************************************************************************/
package org.topcased.modeler.network.netdiag;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.requests.CreationFactory;
import org.topcased.modeler.editor.GraphElementCreationFactory;
import org.topcased.modeler.editor.ICreationUtils;
import org.topcased.modeler.editor.palette.ModelerConnectionCreationToolEntry;
import org.topcased.modeler.editor.palette.ModelerCreationToolEntry;
import org.topcased.modeler.editor.palette.ModelerPaletteManager;
import org.topcased.network.NetworkPackage;

/**
 * Generated Palette Manager
 *
 * @generated
 */
public class NetworkDiagramPaletteManager extends ModelerPaletteManager {
	// declare all the palette categories of the diagram
	/**
	 * @generated
	 */
	private PaletteDrawer objectsDrawer;
	/**
	 * @generated
	 */
	private PaletteDrawer linksDrawer;

	/**
	 * @generated
	 */
	private ICreationUtils creationUtils;

	/**
	 * The Constructor
	 *
	 * @param utils the creation utils for the tools of the palette 
	 * @generated
	 */
	public NetworkDiagramPaletteManager(ICreationUtils utils) {
		super();
		this.creationUtils = utils;
	}

	/**
	 * Creates the main categories of the palette
	 *
	 * @generated
	 */
	protected void createCategories() {
		createObjectsDrawer();
		createLinksDrawer();
	}

	/**
	 * Updates the main categories of the palette
	 *
	 * @generated
	 */
	protected void updateCategories() {
		// deletion of the existing categories and creation of the updated categories

		getRoot().remove(objectsDrawer);
		createObjectsDrawer();

		getRoot().remove(linksDrawer);
		createLinksDrawer();
	}

	/**
	 * Creates the Palette container containing all the Palette entries for each figure.
	 *
	 * @generated
	 */
	private void createObjectsDrawer() {
		objectsDrawer = new PaletteDrawer("Objects", null);
		List entries = new ArrayList();

		CreationFactory factory;

		factory = new GraphElementCreationFactory(creationUtils,
				NetworkPackage.eINSTANCE.getNetwork(), "default");
		entries
				.add(new ModelerCreationToolEntry("Network", "Network",
						factory, NetworkDiagramImageRegistry
								.getImageDescriptor("NETWORK"),
						NetworkDiagramImageRegistry
								.getImageDescriptor("NETWORK_LARGE")));

		factory = new GraphElementCreationFactory(creationUtils,
				NetworkPackage.eINSTANCE.getComputer(), "default");
		entries.add(new ModelerCreationToolEntry("Computer", "Computer",
				factory, NetworkDiagramImageRegistry
						.getImageDescriptor("COMPUTER"),
				NetworkDiagramImageRegistry
						.getImageDescriptor("COMPUTER_LARGE")));

		factory = new GraphElementCreationFactory(creationUtils,
				NetworkPackage.eINSTANCE.getInternet(), "default");
		entries.add(new ModelerCreationToolEntry("Internet", "Internet",
				factory, NetworkDiagramImageRegistry
						.getImageDescriptor("INTERNET"),
				NetworkDiagramImageRegistry
						.getImageDescriptor("INTERNET_LARGE")));

		objectsDrawer.addAll(entries);
		getRoot().add(objectsDrawer);
	}

	/**
	 * Creates the Palette container containing all the Palette entries for each figure.
	 *
	 * @generated
	 */
	private void createLinksDrawer() {
		linksDrawer = new PaletteDrawer("Links", null);
		List entries = new ArrayList();

		CreationFactory factory;

		factory = new GraphElementCreationFactory(creationUtils,
				NetworkDiagramSimpleObjectConstants.SIMPLE_OBJECT_LINKS,
				"default", false);
		entries.add(new ModelerConnectionCreationToolEntry("Link", "Link",
				factory, NetworkDiagramImageRegistry
						.getImageDescriptor("LINKS"),
				NetworkDiagramImageRegistry.getImageDescriptor("LINKS_LARGE")));

		linksDrawer.addAll(entries);
		getRoot().add(linksDrawer);
	}

}
