/*******************************************************************************
 * Copyright (C) Ken Webb 2007
 ******************************************************************************/
package org.topcased.modeler.network.netdiag;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.topcased.modeler.di.model.Diagram;
import org.topcased.modeler.di.model.GraphEdge;
import org.topcased.modeler.di.model.GraphNode;
import org.topcased.modeler.di.model.SimpleSemanticModelElement;
import org.topcased.modeler.edit.EMFGraphEdgeEditPart;
import org.topcased.modeler.edit.EMFGraphNodeEditPart;
import org.topcased.modeler.edit.GraphEdgeEditPart;
import org.topcased.modeler.edit.GraphNodeEditPart;
import org.topcased.modeler.network.netdiag.edit.ComputerEditPart;
import org.topcased.modeler.network.netdiag.edit.InternetEditPart;
import org.topcased.modeler.network.netdiag.edit.LinksEditPart;
import org.topcased.modeler.network.netdiag.edit.NetworkDiagramDiagramEditPart;
import org.topcased.modeler.network.netdiag.edit.NetworkEditPart;
import org.topcased.modeler.network.netdiag.edit.NodeEditPart;
import org.topcased.modeler.utils.Utils;
import org.topcased.network.util.NetworkSwitch;

/**
 * Part Factory : associates a model object to its controller. <br>
 *
 * @generated
 */
public class NetworkDiagramEditPartFactory implements EditPartFactory {
	/**
	 * @see org.eclipse.gef.EditPartFactory#createEditPart(org.eclipse.gef.EditPart,java.lang.Object)
	 * @generated
	 */
	public EditPart createEditPart(EditPart context, Object model) {
		if (model instanceof Diagram) {
			return new NetworkDiagramDiagramEditPart((Diagram) model);
		} else if (model instanceof GraphNode) {
			final GraphNode node = (GraphNode) model;
			EObject element = Utils.getElement(node);
			if (element != null) {
				Object editPart = null;

				if ("http://www.topcased.org/network/1.0".equals(element
						.eClass().getEPackage().getNsURI())) {
					editPart = new NodeNetworkSwitch(node).doSwitch(element);
				}

				return (EditPart) editPart;
			}

			if (node.getSemanticModel() instanceof SimpleSemanticModelElement) {
				// Manage the Element that are not associated with a model object
			}
			return new GraphNodeEditPart(node);
		} else if (model instanceof GraphEdge) {
			final GraphEdge edge = (GraphEdge) model;
			EObject element = Utils.getElement(edge);
			if (element != null) {
				Object editPart = null;

				if ("http://www.topcased.org/network/1.0".equals(element
						.eClass().getEPackage().getNsURI())) {
					editPart = new EdgeNetworkSwitch(edge).doSwitch(element);
				}

				return (EditPart) editPart;
			}

			if (edge.getSemanticModel() instanceof SimpleSemanticModelElement) {
				// Manage the Element that are not associated with a model object
				if (NetworkDiagramSimpleObjectConstants.SIMPLE_OBJECT_LINKS
						.equals(((SimpleSemanticModelElement) edge
								.getSemanticModel()).getTypeInfo())) {
					return new LinksEditPart(edge);
				}
			}

			return new GraphEdgeEditPart(edge);
		}

		throw new IllegalStateException(
				"No edit part matches with the '"
						+ model.getClass().getName()
						+ "' model element. Check NetworkDiagramEditPartFactory#createEditPart(EditPart,Object) class");
	}

	/**
	 * @generated
	 */
	private class NodeNetworkSwitch extends NetworkSwitch {
		/**
		 * The graphical node
		 * @generated
		 */
		private GraphNode node;

		/**
		 * Constructor
		 * 
		 * @param node the graphical node
		 * @generated
		 */
		public NodeNetworkSwitch(GraphNode node) {
			this.node = node;
		}

		/**
		 * @see org.topcased.network.util.NetworkSwitch#caseNetwork(org.topcased.network.Network)
		 * @generated
		 */
		public Object caseNetwork(org.topcased.network.Network object) {
			return new NetworkEditPart(node);
		}

		/**
		 * @see org.topcased.network.util.NetworkSwitch#caseNode(org.topcased.network.Node)
		 * @generated
		 */
		public Object caseNode(org.topcased.network.Node object) {
			return new NodeEditPart(node);
		}

		/**
		 * @see org.topcased.network.util.NetworkSwitch#caseComputer(org.topcased.network.Computer)
		 * @generated
		 */
		public Object caseComputer(org.topcased.network.Computer object) {
			return new ComputerEditPart(node);
		}

		/**
		 * @see org.topcased.network.util.NetworkSwitch#caseInternet(org.topcased.network.Internet)
		 * @generated
		 */
		public Object caseInternet(org.topcased.network.Internet object) {
			return new InternetEditPart(node);
		}

		/**
		 * @see org.topcased.network.util.NetworkSwitch#defaultCase(org.eclipse.emf.ecore.EObject)
		 * @generated
		 */
		public Object defaultCase(EObject object) {
			return new EMFGraphNodeEditPart(node);
		}
	}

	/**
	 * @generated
	 */
	private class EdgeNetworkSwitch extends NetworkSwitch {
		/**
		 * The graphical edge
		 * @generated
		 */
		private GraphEdge edge;

		/**
		 * Constructor
		 * 
		 * @param edge the graphical edge
		 * @generated
		 */
		public EdgeNetworkSwitch(GraphEdge edge) {
			this.edge = edge;
		}

		/**
		 * @see org.topcased.network.util.NetworkSwitch#defaultCase(org.eclipse.emf.ecore.EObject)
		 * @generated
		 */
		public Object defaultCase(EObject object) {
			return new EMFGraphEdgeEditPart(edge);
		}
	}

}