/*******************************************************************************
 * Copyright (C) Ken Webb 2007
 ******************************************************************************/
package org.topcased.modeler.network.netdiag;

import org.eclipse.emf.ecore.EObject;
import org.topcased.modeler.di.model.GraphElement;
import org.topcased.modeler.editor.AbstractCreationUtils;
import org.topcased.modeler.graphconf.DiagramGraphConf;
import org.topcased.network.util.NetworkSwitch;

/**
 * This utility class allows to create a GraphElement associated with a Model Object
 *
 * @generated
 */
public class NetworkDiagramCreationUtils extends AbstractCreationUtils {

	/**
	 * Constructor
	 *
	 * @param diagramConf the Diagram Graphical Configuration
	 * @generated
	 */
	public NetworkDiagramCreationUtils(DiagramGraphConf diagramConf) {
		super(diagramConf);
	}

	/**
	 * @generated
	 */
	private class GraphicNetworkSwitch extends NetworkSwitch {
		/**
		 * The presentation of the graphical element
		 *
		 * @generated
		 */
		private String presentation;

		/**
		 * Constructor
		 *
		 * @param presentation the presentation of the graphical element
		 * @generated
		 */
		public GraphicNetworkSwitch(String presentation) {
			this.presentation = presentation;
		}

		/**
		 * @see org.topcased.network.util.NetworkSwitch#caseNetwork(org.topcased.network.Network)
		 * @generated
		 */
		public Object caseNetwork(org.topcased.network.Network object) {
			if ("default".equals(presentation)) {
				return createGraphElementNetwork(object, presentation);
			}
			return null;
		}

		/**
		 * @see org.topcased.network.util.NetworkSwitch#caseComputer(org.topcased.network.Computer)
		 * @generated
		 */
		public Object caseComputer(org.topcased.network.Computer object) {
			if ("default".equals(presentation)) {
				return createGraphElementComputer(object, presentation);
			}
			return null;
		}

		/**
		 * @see org.topcased.network.util.NetworkSwitch#caseInternet(org.topcased.network.Internet)
		 * @generated
		 */
		public Object caseInternet(org.topcased.network.Internet object) {
			if ("default".equals(presentation)) {
				return createGraphElementInternet(object, presentation);
			}
			return null;
		}

		/**
		 * @see org.topcased.network.util.NetworkSwitch#defaultCase(org.eclipse.emf.ecore.EObject)
		 * @generated
		 */
		public Object defaultCase(EObject object) {
			return null;
		}
	}

	/**
	 * @see org.topcased.modeler.editor.ICreationUtils#createGraphElement(org.eclipse.emf.ecore.EObject, java.lang.String)
	 * @generated
	 */
	public GraphElement createGraphElement(EObject obj, String presentation) {
		Object graphElt = null;

		if ("http://www.topcased.org/network/1.0".equals(obj.eClass()
				.getEPackage().getNsURI())) {
			graphElt = new GraphicNetworkSwitch(presentation).doSwitch(obj);
		}

		return (GraphElement) graphElt;
	}

	/**
	 * @param element the model element
	 * @param presentation the presentation of the graphical element
	 * @return the complete GraphElement
	 * @generated
	 */
	protected GraphElement createGraphElementNetwork(
			org.topcased.network.Network element, String presentation) {
		return createGraphNode(element, presentation);
	}

	/**
	 * @param element the model element
	 * @param presentation the presentation of the graphical element
	 * @return the complete GraphElement
	 * @generated
	 */
	protected GraphElement createGraphElementComputer(
			org.topcased.network.Computer element, String presentation) {
		return createGraphNode(element, presentation);
	}

	/**
	 * @param element the model element
	 * @param presentation the presentation of the graphical element
	 * @return the complete GraphElement
	 * @generated
	 */
	protected GraphElement createGraphElementInternet(
			org.topcased.network.Internet element, String presentation) {
		return createGraphNode(element, presentation);
	}

	/**
	 * Create the ModelObject with its initial children
	 * 
	 * @param obj the model object
	 * @return the model object with its children
	 * @generated
	 */
	public EObject createModelObject(EObject obj) {
		return obj;
	}

}
